import React from 'react';
import { User, LogOut, Settings, Shield } from 'lucide-react';

interface ProfileViewProps {
  user: any;
  onLogout: () => void;
}

export const ProfileView: React.FC<ProfileViewProps> = ({ user, onLogout }) => {
  return (
    <div className="max-w-4xl mx-auto px-4 py-6">
      <div className="bg-white rounded-lg shadow-sm border border-gray-200">
        <div className="p-6 border-b border-gray-200">
          <div className="flex items-center space-x-4">
            <div className="h-16 w-16 bg-blue-600 rounded-full flex items-center justify-center">
              <User className="h-8 w-8 text-white" />
            </div>
            <div>
              <h2 className="text-2xl font-bold text-gray-900">{user.name}</h2>
              <p className="text-gray-600">{user.email}</p>
              <span className="inline-block bg-green-100 text-green-800 px-2 py-1 rounded-full text-sm mt-2">
                Conectado
              </span>
            </div>
          </div>
        </div>

        <div className="p-6 space-y-4">
          <div className="flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-50 cursor-pointer">
            <Settings className="h-5 w-5 text-gray-500" />
            <span className="text-gray-700">Configuración</span>
          </div>
          
          <div className="flex items-center space-x-3 p-3 rounded-lg hover:bg-gray-50 cursor-pointer">
            <Shield className="h-5 w-5 text-gray-500" />
            <span className="text-gray-700">Seguridad</span>
          </div>
          
          <div className="border-t border-gray-200 pt-4">
            <button
              onClick={onLogout}
              className="flex items-center space-x-3 p-3 rounded-lg hover:bg-red-50 text-red-600 cursor-pointer w-full"
            >
              <LogOut className="h-5 w-5" />
              <span>Cerrar Sesión</span>
            </button>
          </div>
        </div>
      </div>
    </div>
  );
};