import React, { useState } from 'react';
import { Navigation } from './Navigation';
import { ClientsView } from './views/ClientsView';
import { ProductsView } from './views/ProductsView';
import { OrdersView } from './views/OrdersView';
import { ProfileView } from './views/ProfileView';

interface MainAppProps {
  user: any;
  onLogout: () => void;
}

export const MainApp: React.FC<MainAppProps> = ({ user, onLogout }) => {
  const [activeView, setActiveView] = useState<string>('clients');

  const renderView = () => {
    switch (activeView) {
      case 'clients':
        return <ClientsView />;
      case 'products':
        return <ProductsView />;
      case 'orders':
        return <OrdersView />;
      case 'profile':
        return <ProfileView user={user} onLogout={onLogout} />;
      default:
        return <ClientsView />;
    }
  };

  return (
    <div className="min-h-screen bg-gray-50">
      <div className="pb-16 md:pb-0">
        {renderView()}
      </div>
      <Navigation activeView={activeView} onViewChange={setActiveView} />
    </div>
  );
};