import React, { useState, useEffect } from 'react';
import { LoginScreen } from './components/LoginScreen';
import { MainApp } from './components/MainApp';
import { OfflineIndicator } from './components/OfflineIndicator';
import { useOfflineStorage } from './hooks/useOfflineStorage';
import { useAuth } from './hooks/useAuth';

function App() {
  const { user, login, logout, isAuthenticated } = useAuth();
  const { isOnline, syncPendingData } = useOfflineStorage();

  useEffect(() => {
    // Auto-sync when coming back online
    if (isOnline) {
      syncPendingData();
    }
  }, [isOnline, syncPendingData]);

  return (
    <div className="min-h-screen bg-gray-50">
      <OfflineIndicator isOnline={isOnline} />
      {isAuthenticated ? (
        <MainApp user={user} onLogout={logout} />
      ) : (
        <LoginScreen onLogin={login} />
      )}
    </div>
  );
}

export default App;